#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
# 5 STAGES RING OSCILLATOR STATIC OUTPUT CHARACTERISTICS - 20 NM DEVICE
# RESISTIVE LOAD WITH PULLDOWN TRANSISTOR - VD = -1.1 V
# LOGIC 0 = -1.1 V  LOGIC 1 = 0 V
#########################################################################################
Device PMOS {
	File {
		Grid		= "ring_oscillator_msh.tdr"
		Plot		= "ring_oscillator"
		Current		= "ring_oscillator"
		Parameter	= "ring_oscillator.par"
	}

	Electrode {
		{ name="Source"    Voltage=0.0 }
		{ name="Drain"     Voltage=0.0 DistResist = SchottkyResist }
		{ name="Gate"      Voltage=0.0 }
	}

	Physics{
		Fermi
		Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
		EffectiveIntrinsicDensity( Bennett )
		Recombination(
		SRH( DopingDep )
#		Band2Band (
#			Model = Hurkx
#			DensityCorrection = Local 
#			ParameterSetName = ("myBTBT") )
		)
		eQuantumPotential
		hQuantumPotential
	}

	Physics(MaterialInterface = "Silicon/SiO2"){
		Traps(
			Acceptor Level EnergyMid=-0.3 fromMidBandGap 
			Conc=4.0e11 eXsection=1e-14  hXsection=1e-14
		)
	}
}

Math{
	Extrapolate
	RelErrControl
	Digits=4
 	Notdamped=50
  	Iterations=64
  	Transient=BE
  	Method=Blocked
  	SubMethod=ParDiSo
}

Plot{
	NonLocal
	eDensity hDensity
	eCurrent hCurrent
	TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
	eMobility hMobility
	eVelocity hVelocity
	eEnormal hEnormal
	ElectricField/Vector Potential SpaceCharge
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	DonorConcentration AcceptorConcentration
	Doping
	eGradQuasiFermi/Vector hGradQuasiFermi/Vector
	eEparallel hEparalllel
	BandGap 
	BandGapNarrowing
	Affinity
	ConductionBand ValenceBand
	eQuantumPotential 
	hQuantumPotential
}

File {
	Output = "@log@"
}

System {
	Vsource_pset vdd (dd 0) { dc = 0.0 }
	Vsource_pset vin (in 0) { dc = 0.0 }

	PMOS M1 ( "Drain" = out1 "Gate" = in "Source" = 0 )
	Resistor_pset r1 ( dd out1 ){ resistance = 100e6 }
	PMOS M2 ( "Drain" = out2 "Gate" = out1 "Source" = 0 )
	Resistor_pset r2 ( dd out2 ){ resistance = 100e6 }
	PMOS M3 ( "Drain" = out3 "Gate" = out2 "Source" = 0 )
	Resistor_pset r3 ( dd out3 ){ resistance = 100e6 }
	PMOS M4 ( "Drain" = out4 "Gate" = out3 "Source" = 0 )
	Resistor_pset r4 ( dd out4 ){ resistance = 100e6 }
	PMOS M5 ( "Drain" = out5 "Gate" = out4 "Source" = 0 )
	Resistor_pset r5 ( dd out5 ){ resistance = 100e6 }
	Plot "n@node@_sys_des.plt" (time() v(in) v(out1) v(out2) v(out3) v(out4) v(out5))
}

Solve {  
	NewCurrentPrefix="init"
	Coupled(Iterations=100){ Poisson }
	Coupled{ Poisson Electron Hole Contact Circuit }

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vdd.dc Voltage= -1.1 } 
	){ Coupled{ M1.poisson M1.electron M1.hole M1.contact
				M2.poisson M2.electron M2.hole M2.contact
				M3.poisson M3.electron M3.hole M3.contact
				M4.poisson M4.electron M4.hole M4.contact
				M5.poisson M5.electron M5.hole M5.contact circuit }
	}

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vin.dc Voltage= -1.1 } 
	){ Coupled{ M1.poisson M1.electron M1.hole M1.contact
				M2.poisson M2.electron M2.hole M2.contact
				M3.poisson M3.electron M3.hole M3.contact
				M4.poisson M4.electron M4.hole M4.contact
				M5.poisson M5.electron M5.hole M5.contact circuit }
	}

	NewCurrentPrefix=""
	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vin.dc Voltage= 0.5 } 
	){ Coupled{ M1.poisson M1.electron M1.hole M1.contact
				M2.poisson M2.electron M2.hole M2.contact
				M3.poisson M3.electron M3.hole M3.contact
				M4.poisson M4.electron M4.hole M4.contact
				M5.poisson M5.electron M5.hole M5.contact circuit }
	}
}

